//
// Copyright (c) 2023 by Simon Hartmann, Mark Zimmermann
//

import Foundation
import WeatherKit

struct DayForecast: Hashable, Identifiable {
    let id = UUID()
    let date: Date
    let highTemperature: Measurement<UnitTemperature>
    let lowTemperature: Measurement<UnitTemperature>
    let symbolName: String
    let rainfallAmount: Measurement<UnitLength>

    var averageTemperature: Measurement<UnitTemperature> {
        (lowTemperature + highTemperature) / 2
    }

    init(from forecast: DayWeather) {
        date = forecast.date
        highTemperature = forecast.highTemperature
        lowTemperature = forecast.lowTemperature
        symbolName = forecast.symbolName
        rainfallAmount = forecast.rainfallAmount
    }

    init(date: Date, highTemperature: Measurement<UnitTemperature>, lowTemperature: Measurement<UnitTemperature>, symbolName: String, rainfallAmount: Measurement<UnitLength>) {
        self.date = date
        self.highTemperature = highTemperature
        self.lowTemperature = lowTemperature
        self.symbolName = symbolName
        self.rainfallAmount = rainfallAmount
    }
}

extension DayForecast {
    static func forPreview(
        date: Date = .now,
        highTemperature: Measurement<UnitTemperature> = .init(value: .random(in: 0 ... 15), unit: .celsius),
        lowTemperature: Measurement<UnitTemperature> = .init(value: .random(in: 16 ... 30), unit: .celsius),
        symbolName: String = "cloud"
    ) -> DayForecast {
        DayForecast(date: date, highTemperature: highTemperature, lowTemperature: lowTemperature, symbolName: symbolName, rainfallAmount: .init(value: .random(in: 0 ... 60), unit: .millimeters))
    }
}
