//
// Copyright (c) 2023 by Simon Hartmann, Mark Zimmermann
//

import Foundation
import WeatherKit

struct HourForecast: Hashable, Identifiable {
    let id = UUID()
    let date: Date
    let temperature: Measurement<UnitTemperature>
    let apperantTemperature: Measurement<UnitTemperature>
    let visibility: Measurement<UnitLength>

    init(from forecast: HourWeather) {
        date = forecast.date

        temperature = forecast.temperature
        apperantTemperature = forecast.apparentTemperature
        visibility = forecast.visibility
    }

    init(date: Date, temperature: Measurement<UnitTemperature>, apperantTemperature: Measurement<UnitTemperature>, visibility: Measurement<UnitLength>) {
        self.date = date
        self.temperature = temperature
        self.apperantTemperature = apperantTemperature
        self.visibility = visibility
    }
}

extension HourForecast {
    static func forPreview(
        date: Date = .now,
        temperature: Measurement<UnitTemperature> = .init(value: .random(in: -10 ... 30), unit: .celsius),
        apperantTemperature: Measurement<UnitTemperature> = .init(value: .random(in: -10 ... 30), unit: .celsius),
        visibility: Measurement<UnitLength> = .init(value: .random(in: 0 ... 16), unit: .kilometers)
    ) -> HourForecast {
        HourForecast(
            date: date,
            temperature: temperature,
            apperantTemperature: apperantTemperature,
            visibility: visibility
        )
    }
}
