//
// Copyright (c) 2023 by Simon Hartmann, Mark Zimmermann
//

import Foundation
import WeatherKit

struct NowWeather: Hashable {
    let date: Date
    let symbolName: String
    let humidity: Double
    let temperature: Measurement<UnitTemperature>

    init(from: CurrentWeather) {
        date = from.date
        symbolName = from.symbolName
        humidity = from.humidity
        temperature = from.temperature
    }

    init(date: Date, symbolName: String, humidity: Double, temperature: Measurement<UnitTemperature>) {
        self.date = date
        self.symbolName = symbolName
        self.humidity = humidity
        self.temperature = temperature
    }
}

extension NowWeather {
    static func forPreview(
        date: Date = .now,
        symbolName: String = ["cloud.rain", "sun.max", "cloud"].randomElement()!,
        humidity: Double = .random(in: 0 ... 100),
        temperature: Measurement<UnitTemperature> = .init(value: .random(in: 0 ... 39), unit: .celsius)
    ) -> NowWeather {
        NowWeather(
            date: date,
            symbolName: symbolName,
            humidity: humidity,
            temperature: temperature
        )
    }
}
