//
// Copyright (c) 2023 by Simon Hartmann, Mark Zimmermann
//

import SwiftUI

struct CurrentWeatherComparisonView: View {
    let citiesWithWeather: [CityWithWeater<NowWeather>]

    var body: some View {
        if let firstCity = citiesWithWeather.first, let secondCity = citiesWithWeather.last,
           let firstCityWeather = firstCity.weather.first, let secondCityWeather = secondCity.weather.last
        {
            ScrollView {
                CitiesView(firstCity: firstCity.city, secondCity: citiesWithWeather.last!.city)

                Text("Das Wetter ohne Worte")
                    .font(.title2.bold())
                    .padding(.top, 30)
                HStack {
                    Image(systemName: firstCityWeather.symbolName)
                    Text("vs.")
                    Image(systemName: secondCityWeather.symbolName)
                }

                Text("Die Temperatur")
                    .font(.title2.bold())
                    .padding(.top, 30)
                HStack {
                    Text("\(firstCityWeather.temperature.converted(to: .celsius).value, specifier: "%.2f") °C")
                    Text("vs.")
                    Text("\(secondCityWeather.temperature.converted(to: .celsius).value, specifier: "%.2f") °C")
                }

                Text("Luftfeuchtigkeit")
                    .font(.title2.bold())
                    .padding(.top, 30)
                HStack {
                    Text("\(firstCityWeather.humidity, specifier: "%.2f") %")
                    Text("vs.")
                    Text("\(secondCityWeather.humidity, specifier: "%.2f") %")
                }
            }
            .frame(maxWidth: .infinity)
            .background(Color(white: 0.97))
        } else {
            Text("Es fehler leider Wetterdaten. Bitte versuchen Sie es erneut.")
        }
    }
}

struct CurrentWeatherComparionView_Previews: PreviewProvider {
    static var previews: some View {
        CurrentWeatherComparisonView(citiesWithWeather: [
            CityWithWeater(city: "Berlin", weather: [NowWeather.forPreview()]),
            CityWithWeater(city: "München", weather: [NowWeather.forPreview()]),
        ])
    }
}
