//
// Copyright (c) 2023 by Simon Hartmann, Mark Zimmermann
//

import Combine
import CoreLocation
import WeatherKit

@MainActor
class WeatherAssistant: ObservableObject {
    @Published var combinedMarkDarkURL: URL?
    @Published var legalPageURL: URL?

    init() {
        Task {
            self.combinedMarkDarkURL = try? await WeatherService.shared.attribution.combinedMarkLightURL
            self.legalPageURL = try? await WeatherService.shared.attribution.legalPageURL
        }
    }

    func getCurrentWeather(location: CLLocationCoordinate2D) async throws -> CurrentWeather {
        return try await WeatherService.shared.weather(for: CLLocation(location), including: .current)
    }

    func getHourWeather(location: CLLocationCoordinate2D) async throws -> Forecast<HourWeather> {
        return try await WeatherService.shared.weather(for: CLLocation(location), including: .hourly(startDate: .now, endDate: .now.advanced(by: .oneHour * 24)))
    }

    func getOneWeekForecast(location: CLLocationCoordinate2D) async throws -> Forecast<DayWeather> {
        try await WeatherService.shared.weather(for: CLLocation(location), including: .daily(startDate: .now, endDate: .now.advanced(by: .oneWeek)))
    }

    enum Errors: LocalizedError {
        case noCurrentLocation

        var errorDescription: String? {
            switch self {
            case .noCurrentLocation:
                return "Die aktuelle Position ist unbekannt."
            }
        }
    }
}
