//
//  ApplicationTabView.swift
//  NavigationSplitView
//
//  Created by Stefan Mayer-Popp on 13.05.23.
//

import SwiftUI

struct ApplicationTabView: View {
  
  @EnvironmentObject var apiDataStore: APIDataStore
  
  var body: some View {
    TabView {
      CatListView(columnVisibility: .constant(.doubleColumn))
        .tabItem {
          Text("Double Column")
          Image(systemName: "globe")
        }
      CatListView(columnVisibility: .constant(.all))
        .tabItem {
          Text("All")
          Image(systemName: "staroflife.fill")
        }
      CatListView(columnVisibility: .constant(.detailOnly))
        .tabItem {
          Text("Detail only")
          Image(systemName: "doc.text")
        }
      CatListView(columnVisibility: .constant(.automatic))
        .tabItem {
          Text("Automatic")
          Image(systemName: "gear")
        }
    }
  }
  
  struct ApplicationTabView_Previews: PreviewProvider {
    static var previews: some View {
      ApplicationTabView()
        .environmentObject(APIDataStore())
    }
  }
}
