//
//  CatBreedView.swift
//  NavigationSplitView
//
//  Created by Stefan Mayer-Popp on 13.05.23.
//

import SwiftUI

struct CatBreedView: View {
  @EnvironmentObject var apiDataStore: APIDataStore
  var breedId: Breed.ID?

  var body: some View {
    // View für eine ausgewählte Rasse
    if let breedId = breedId, let breed = apiDataStore.breed(id: breedId) {
      VStack {
        // Rasseninformationen
        Text(breed.breed)
          .font(.largeTitle)
        Text("Coat: \(breed.coat)")
          .font(.title)
        Text(breed.country)
          .font(.largeTitle)
          .fontWeight(.thin)
          .italic()
          .padding()
        
        // Zufälliges Bild :)
        AsyncImage(url:  URL(string: "https://cataas.com/cat?width=200&a=\(breedId)")) { image in
          image.resizable().aspectRatio(contentMode: .fit)
        } placeholder: {
          ProgressView()
        }
      }
    } else {
      // View falls keine Rasse gewählt wurde
      VStack {
        Text("Wähle eine Katzenrasse")
          .font(.title)
      }
    }
  }
}

struct CatBreedView_Previews: PreviewProvider {
  static var previews: some View {
    CatBreedView()
  }
}



