//
//  CatListView.swift
//  NavigationSplitView
//
//  Created by Stefan Mayer-Popp on 13.05.23.
//

import SwiftUI

struct CatListView: View {
  @EnvironmentObject var apiDataStore: APIDataStore
  @State private var coatID: String.ID?
  @State private var columnVisibility: NavigationSplitViewVisibility = .all
  @State private var breedID: Breed.ID?
  
  var body: some View {
    // Coats
    NavigationSplitView(columnVisibility: $columnVisibility) {
      List(apiDataStore.coats ?? [], selection: $coatID) { coat in
        Text(coat)
          .font(.title)
      }
      .navigationTitle("Coats")
    } content: {
      // Get breeds by coat
      if let coatID = coatID, let breeds = apiDataStore.breedsBy(coatID: coatID) {
        List(breeds, selection: $breedID) { breed in
          Text(breed.breed)
            .font(.title)
        }
        .navigationTitle("Breeds")
      } else {
        VStack {
          Text("Select Coat")
            .font(.title)
        }
        .padding()
      }
    } detail: {
      // Detail Ansicht
      CatBreedView(breedId: breedID)
    }
    .navigationSplitViewStyle(.balanced)
    // Detailansicht schließen, wenn coatID sich ändert
    .onChange(of: coatID) { _ in
      breedID = nil
    }
    // Spaltenlayout ändern wenn breedID sich ändert
    .onChange(of: breedID) { _ in
      if breedID != nil {
        // Wenn breedId gesetzt, schalte auf Double Column
        columnVisibility = .doubleColumn
      } else {
        // Wenn breedId leer ist, zeige alle Spalten
        columnVisibility = .all
      }
    }
  }

  struct CatListView_Previews: PreviewProvider {
    static var previews: some View {
      CatListView()
        .environmentObject(APIDataStore())
    }
  }
}
