//
//  CatListView.swift
//  NavigationSplitView
//
//  Created by Stefan Mayer-Popp on 13.05.23.
//

import SwiftUI

struct CatListView: View {
  @EnvironmentObject var apiDataStore: APIDataStore
  @Binding var columnVisibility: NavigationSplitViewVisibility
  @State private var breedId: Breed.ID?
  
  var filteredBreeds: [Breed]? {
    guard apiDataStore.breedsFilter.isEmpty == false else {
      return apiDataStore.breeds?.data
    }
    
    return apiDataStore.breeds?.data.filter({ breed in
      breed.breed.lowercased().contains(apiDataStore.breedsFilter.lowercased())
    })
  }
  
  var body: some View {
    NavigationSplitView(columnVisibility: $columnVisibility) {
      List(filteredBreeds ?? [], selection: $breedId) { breed in
        Text(breed.breed)
          .font(.title)
      }
      .navigationTitle("Breeds")
      .searchable(text: $apiDataStore.breedsFilter)
    } detail: {
      CatBreedView(breedId: breedId)
    }
    .navigationSplitViewStyle(.balanced)
  }
  
  struct CatListView_Previews: PreviewProvider {
    static var previews: some View {
      CatListView(columnVisibility: .constant(.automatic))
        .environmentObject(APIDataStore())
    }
  }
}
