//
//  Entity+Extension.swift
//  HeiseVision
//
//  Created by Gero Gerber on 26.07.23.
//

import Combine
import Foundation
import RealityKit

extension Entity {
    func addSkybox(name: String) async {
        do {
            let texture = try await TextureResource(named: name)
            var material = UnlitMaterial()
            material.color = .init(texture: .init(texture))
            components.set(ModelComponent(
                mesh: .generateSphere(radius: 2000),
                materials: [material]
            ))
            scale *= .init(x: -1, y: 1, z: 1)
        } catch {
            print(error.localizedDescription)
        }
    }
    
    func setSunlight(intensity: Float) {
        Task {
            do {
                let resource = try await EnvironmentResource(named: "Sunlight")
                var iblComponent = ImageBasedLightComponent(
                    source: .single(resource),
                    intensityExponent: intensity)
                
                // Ensure that the light rotates with its entity. Omit this line
                // for a light that remains fixed relative to the surroundings.
                iblComponent.inheritsRotation = true
                
                components.set(iblComponent)
                components.set(ImageBasedLightReceiverComponent(imageBasedLight: self))
            } catch {
                print(error.localizedDescription)
            }
        }
    }
}
