//
//  HeiseVisionApp.swift
//  HeiseVision
//
//  Created by Gero Gerber on 24.07.23.
//

import SwiftUI

@main
struct HeiseVisionApp: App {
    @State private var immersionStyle: ImmersionStyle = .mixed

    var body: some Scene {
        WindowGroup {
            ContentView(immersionStyle: $immersionStyle)
        }
        
        WindowGroup(id: "SimpleRealityView") {
            SimpleRealityView()
        }
        
        WindowGroup(id: "UIDepth") {
            UIDepthView()
        }
        
        WindowGroup(id: "Ornaments") {
            OrnamentView()
        }
        
        WindowGroup(id: "AssetsView") {
            AssetsView()
        }
        
        WindowGroup(id: "SimpleModel") {
            SimpleModelView()
        }
        .windowStyle(.volumetric)
        
        WindowGroup(id: "VolumeView") {
            VolumeView()
        }
        .windowStyle(.volumetric)
        
        ImmersiveSpace(id: "ImmersiveView") {
            ImmersiveView()
        }
        .immersionStyle(selection: $immersionStyle, in: .full, .mixed, .progressive)
        
        ImmersiveSpace(id: "SampleARView") {
            SampleARView()
        }
    }
}
