//
//  ImmersiveView.swift
//  HeiseVision
//
//  Created by Gero Gerber on 24.07.23.
//

import RealityKit
import SwiftUI

struct ImmersiveView: View {
    var body: some View {
            RealityView { content in
                let robot = try! await ModelEntity(named: "robot_walk_idle")
                robot.transform.translation.y = 1.5
                robot.transform.translation.z = -1
                content.add(robot)
                
                robot.setSunlight(intensity: 14)
                
                let skyBox = Entity()
                await skyBox.addSkybox(name: "park_scene")
                content.add(skyBox)
            }
    }
}

#Preview {
    ImmersiveView()
}
