//
//  SampleARModel.swift
//  HeiseVision
//
//  Created by Gero Gerber on 26.07.23.
//

import ARKit
import QuartzCore
import Foundation

@MainActor
class SampleARModel: ObservableObject {
    private var session = ARKitSession()
    private var worldTrackingProvider = WorldTrackingProvider()
    
    init() {
        print("WorldTrackingProvider supported: \(WorldTrackingProvider.isSupported)")
        print("PlaneDetectionProvider supported: \(PlaneDetectionProvider.isSupported)")
        print("ImageTrackingProvider supported: \(ImageTrackingProvider.isSupported)")
        print("SceneReconstructionProvider supported: \(SceneReconstructionProvider.isSupported)")
        print("HandTrackingProvider supported: \(HandTrackingProvider.isSupported)")
    }
    func start() async {
        guard WorldTrackingProvider.isSupported else { return }

        do {
            try await session.run([worldTrackingProvider])
        } catch {
            print(error.localizedDescription)
        }
    }
    
    func stop() async {
        session.stop()
    }
    
    func worldTrackingEventHandler() async {
        for await anchor in worldTrackingProvider.anchorUpdates {
            print(anchor)
        }
    }
    
    func sessionEventHandler() async {
        for await event in session.events {
            print(event)
        }
    }
    
    func queryDeviceAnchor() -> DeviceAnchor? {
        worldTrackingProvider.queryDeviceAnchor(atTimestamp: CACurrentMediaTime())
    }
}
