//
//  VolumeView.swift
//  HeiseVision
//
//  Created by Gero Gerber on 24.07.23.
//

import RealityKit
import SwiftUI

struct VolumeView: View {
    var body: some View {
        Model3D(named: "robot_walk_idle") { phase in
            switch phase {
                case .empty:
                    ProgressView()
                case .failure(let error):
                    Text(error.localizedDescription)
                case .success(let model):
                    model
                        .resizable()
                        .aspectRatio(contentMode: .fit)
                @unknown default:
                    fatalError()
            }
        }
    }
}

#Preview {
    VolumeView()
}
