//
//  AssetsView.swift
//  HeiseVision
//
//  Created by Gero Gerber on 31.07.23.
//

import RealityKit
import RealityKitContent
import SwiftUI

struct AssetsView: View {
    @StateObject var model = AssetsModel()
    let orientation: SIMD3<Float> = .init(x: 0, y: .pi / 6.0, z: 0)
    var body: some View {
        NavigationSplitView {
            List(model.assets, id: \.asset) { asset in
                Text(asset.name)
                    .onTapGesture {
                        model.selected = asset
                    }
            }
            .navigationTitle("Assets")
        } detail: {
            VStack {
                if let selected = model.selected {
                    VStack {
                        Model3D(named: selected.asset) { model in
                            model
                                .resizable()
                                .aspectRatio(contentMode: .fit)
                                .rotation3DEffect(Rotation3D(eulerAngles: .init(angles: orientation, order: .xyz)))
                        } placeholder: {
                            ProgressView()
                        }
                        .padding(.bottom, 50)
                    }
                    Text(selected.name)
                } else {
                    Text("Nothing selected")
                }
            }
            .navigationTitle("Content")
            .padding()
        }
    }
}

#Preview {
    AssetsView()
}
