//
//  UIDepthView.swift
//  HeiseVision
//
//  Created by Gero Gerber on 26.07.23.
//

import SwiftUI

struct UIDepthView: View {
    var body: some View {
        ZStack {
            colorLayer(color: .red, padding: 0, depth: 0)
            colorLayer(color: .green, padding: 40, depth: 40)
            colorLayer(color: .blue, padding: 80, depth: 0)
        }
        .padding()
    }
    
    private func colorLayer(color: Color, padding: CGFloat, depth: CGFloat) -> some View {
        color
            .clipShape(RoundedRectangle(cornerSize: CGSize(width: 45, height: 45)))
            .padding(padding)
            .frame(depth: depth)
    }
}

#Preview {
    UIDepthView()
}
