// swift-tools-version: 5.9
// The swift-tools-version declares the minimum version of Swift required to build this package.

import CompilerPluginSupport
import PackageDescription

let package = Package(
    name: "TrackChange",
    platforms: [.macOS(.v14), .iOS(.v17)],
    products: [
        .library(
            name: "TrackChange",
            targets: ["TrackChange"]
        ),
        .executable(
            name: "TrackChangeClient",
            targets: ["TrackChangeClient"]
        )
    ],
    dependencies: [
        // Depend on the Swift 5.9 release of SwiftSyntax
        .package(url: "https://github.com/apple/swift-syntax.git", from: "509.0.0")
    ],
    targets: [
        .macro(
            name: "TrackChangeMacros",
            dependencies: [
                .product(name: "SwiftSyntaxMacros", package: "swift-syntax"),
                .product(name: "SwiftCompilerPlugin", package: "swift-syntax")
            ]
        ),

        // Library that exposes a macro as part of its API, which is used in client programs.
        .target(name: "TrackChange", dependencies: ["TrackChangeMacros"]),

        // A client of the library, which is able to use the macro in its own code.
        .executableTarget(name: "TrackChangeClient", dependencies: ["TrackChange"]),

        // A test target used to develop the macro implementation.
        .testTarget(
            name: "TrackChangeTests",
            dependencies: [
                "TrackChangeMacros",
                .product(name: "SwiftSyntaxMacrosTestSupport", package: "swift-syntax")
            ]
        )
    ]
)
