//
//  Heise Swift Macros
//  Copyright © 2023 Gero Gerber. All rights reserved.
//

import Foundation
import SwiftDiagnostics

public enum TrackChangeDiagnostic: String, DiagnosticMessage {
    case parameterNotATuple

    public var severity: DiagnosticSeverity {
        .error
    }

    public var message: String {
        switch self {
            case .parameterNotATuple:
                "Parameter must be a tuple of two closures"
        }
    }

    public var diagnosticID: MessageID {
        MessageID(domain: "TrackChangeMacros", id: rawValue)
    }
}
