//
//  Heise Swift Macros
//  Copyright © 2023 Gero Gerber. All rights reserved.
//

import SwiftSyntaxMacros
import SwiftSyntaxMacrosTestSupport
import XCTest

#if canImport(TrackChangeMacros)
    import TrackChangeMacros

    let testMacros: [String: Macro.Type] = [
        "TrackChange": TrackChangeMacro.self
    ]
#endif

final class TrackChangeTests: XCTestCase {
    func test_With_Closure_Signature() throws {
        #if canImport(TrackChangeMacros)
            assertMacroExpansion(
                """
                #TrackChange(({ [weak self] in _ = self?.name }, { [weak self] in print(self?.name) }))
                """,
                expandedSource: """
                {
                    __macro_local_11trackChangefMu_()
                    @Sendable func __macro_local_11trackChangefMu_() {
                        withObservationTracking { [weak self] in
                            _ = self?.name
                        } onChange: { [weak self] in
                            print(self?.name)
                            __macro_local_11trackChangefMu_()
                        }
                    }
                }()
                """,
                macros: testMacros
            )
        #else
            throw XCTSkip("macros are only supported when running tests for the host platform")
        #endif
    }

    func test_Without_Closure_Signature() throws {
        #if canImport(TrackChangeMacros)
            assertMacroExpansion(
                """
                #TrackChange(({ _ = self.name }, { print(self.name) }))
                """,
                expandedSource: """
                {
                    __macro_local_11trackChangefMu_()
                    @Sendable func __macro_local_11trackChangefMu_() {
                        withObservationTracking {
                            _ = self.name
                        } onChange: {
                            print(self.name)
                            __macro_local_11trackChangefMu_()
                        }
                    }
                }()
                """,
                macros: testMacros
            )
        #else
            throw XCTSkip("macros are only supported when running tests for the host platform")
        #endif
    }

    func test_Without_Closure_Parameters() throws {
        #if canImport(TrackChangeMacros)
            assertMacroExpansion(
                """
                #TrackChange((1, 1))
                """,
                expandedSource:
                """
                {
                }()
                """,
                diagnostics: [
                    DiagnosticSpec(message: "Parameter must be a tuple of two closures", line: 1, column: 1)
                ],
                macros: testMacros
            )
        #else
            throw XCTSkip("macros are only supported when running tests for the host platform")
        #endif
    }
}
