import 'package:accessibility_tools/accessibility_tools.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:share_plus/share_plus.dart';
import 'package:magazindownloader/magazine.dart';

class MagazineDetailPage extends StatefulWidget {
  final Magazine magazine;

  const MagazineDetailPage({super.key, required this.magazine});

  @override
  State<MagazineDetailPage> createState() => _MagazineDetailPageState();
}

class _MagazineDetailPageState extends State<MagazineDetailPage> {
  final transformationController = TransformationController();
  bool zoomed = false;

  Future _shareCover() async {
    final data =
        await rootBundle.load('assets/${widget.magazine.filename}.webp');
    final buffer = data.buffer;
    await Share.shareXFiles(
      [
        XFile.fromData(
          buffer.asUint8List(data.offsetInBytes, data.lengthInBytes),
          name: '${widget.magazine.filename}.webp',
          mimeType: 'image/webp',
        ),
      ],
    );
  }

  @override
  Widget build(BuildContext context) {
    return AccessibilityTools(
      child: Scaffold(
        appBar: AppBar(automaticallyImplyLeading: true),
        body: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Container(
              padding: const EdgeInsets.all(40),
              color: Colors.blue.withOpacity(0.2),
              child: Semantics(
                image: true,
                label: 'Titelcover von ${widget.magazine.name}',
                child: InteractiveViewer(
                  panEnabled: zoomed,
                  transformationController: transformationController,
                  child: Image.asset('assets/${widget.magazine.filename}.webp'),
                ),
              ),
            ),
            const SizedBox(height: 16),
            MergeSemantics(
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Semantics(
                    label: 'Toggle',
                    value: 'aus',
                    child: ExcludeSemantics(
                      child: Switch.adaptive(
                        value: false,
                        onChanged: (value) {},
                      ),
                    ),
                  ),
                  const Text('als gelesen markieren'),
                ],
              ),
            ),
            const SizedBox(height: 16),
            GestureDetector(
              onTap: () {
                setState(() {
                  if (zoomed) {
                    transformationController.value = Matrix4.identity();
                  } else {
                    transformationController.value = Matrix4.identity()
                      ..scale(2.0);
                  }
                  zoomed = !zoomed;
                });
              },
              child: const Text('Zoom'),
            ),
            Semantics(
              button: true,
              label: 'Downloadbutton',
              excludeSemantics: true,
              hint:
                  'Downloaded das Magazin mit dem Namen ${widget.magazine.name}',
              child: ElevatedButton(
                child: Text('Download ${widget.magazine.name}'),
                onPressed: () => _shareCover(),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
