import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:magazindownloader/magazine_detail_page.dart';

import 'magazine.dart';

class MagazineOverviewPage extends StatelessWidget {
  final List<Magazine> magazines;

  const MagazineOverviewPage({super.key, required this.magazines});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: const Text('Mac & I Sammlung')),
      body: GridView.count(
        childAspectRatio: 0.75,
        crossAxisCount: 2,
        mainAxisSpacing: 16,
        children: magazines
            .map(
              (e) => GestureDetector(
                onTap: () => Navigator.of(context).push(CupertinoPageRoute(
                  builder: (_) => MagazineDetailPage(magazine: e),
                )),
                child: Image.asset('assets/${e.filename}.webp'),
              ),
            )
            .toList(),
      ),
    );
  }
}
