import 'package:accessibility_tools/accessibility_tools.dart';
import 'package:flutter/material.dart';
import 'package:magazindownloader/magazine.dart';
import 'package:magazindownloader/magazine_overview_page.dart';

void main() {
  runApp(MyApp());
}

class MyApp extends StatelessWidget {
  final _magazines = [
    Magazine(filename: 'mac_i_cover_01_2024', name: 'Mac & I, 01 2024'),
    Magazine(filename: 'mac_i_cover_02_2024', name: 'Mac & I, 02 2024'),
    Magazine(filename: 'mac_i_cover_03_2023', name: 'Mac & I, 03 2023'),
    Magazine(filename: 'mac_i_cover_04_2023', name: 'Mac & I, 04 2023'),
    Magazine(filename: 'mac_i_cover_05_2023', name: 'Mac & I, 05 2023'),
    Magazine(filename: 'mac_i_cover_06_2023', name: 'Mac & I, 06 2023'),
  ];
  MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Flutter Demo',
      debugShowCheckedModeBanner: false,
      theme: ThemeData(
        colorScheme: ColorScheme.fromSeed(seedColor: Colors.deepPurple),
        useMaterial3: true,
      ),
      home: MagazineOverviewPage(
        magazines: _magazines,
      ),
    );
  }
}
