import 'dart:async';

import 'package:flutter/rendering.dart';
import 'package:flutter_test/flutter_test.dart';

import 'package:magazindownloader/main.dart';

void main() {
  testWidgets('Beispiel des Semantics Tests', (WidgetTester tester) async {
    final handle = tester.ensureSemantics();
    await tester.pumpWidget(MyApp());
    const heiseTapTargetGuideline = MinimumTapTargetGuideline(
      size: Size(55.0, 55.0),
      link: 'https://heise.de',
    );
    expect(tester, meetsGuideline(HeiseGuideline()));
    handle.dispose();
  });
}

class HeiseGuideline extends AccessibilityGuideline {
  @override
  String get description => 'Jedes Element muss tapbar sein';

  @override
  FutureOr<Evaluation> evaluate(WidgetTester tester) {
    Evaluation result = const Evaluation.pass();

    for (final view in tester.binding.renderViews) {
      final semanticsData =
          view.owner!.semanticsOwner!.rootSemanticsNode!.getSemanticsData();
      semanticsData.hasAction(SemanticsAction.tap)
          ? result += const Evaluation.pass()
          : result += const Evaluation.fail('No tappable element found');
    }

    return result;
  }
}
