//
//  Heise Vision Pro
//  Copyright © 2024 Gero Gerber. All rights reserved.
//

import Foundation
import SwiftUI

extension Color {
    var asFloat4: SIMD4<Float> {
        let uiColor = UIColor(self)

        // Get the RGBA components
        var red: CGFloat = 0
        var green: CGFloat = 0
        var blue: CGFloat = 0
        var alpha: CGFloat = 0

        // Extract RGBA values
        uiColor.getRed(&red, green: &green, blue: &blue, alpha: &alpha)

        return SIMD4<Float>(Float(red), Float(green), Float(blue), Float(alpha))
    }
}
