//
//  Heise Vision Pro
//  Copyright © 2024 Gero Gerber. All rights reserved.
//

import SwiftUI

@main
struct HeiseVisionProApp: App {
    @State private var appModel = AppModel()

    var body: some Scene {
        WindowGroup {
            MainView()
                .environment(appModel)
                .task {
                    await appModel.loadAssets()
                }
        }
        .windowResizability(.contentSize)

        WindowGroup(id: AppModel.directionalLightWindowId) {
            DirectionalLightView()
        }
        .windowStyle(.volumetric)

        WindowGroup(id: AppModel.spotLightWindowId) {
            SpotLightView()
        }
        .windowStyle(.volumetric)

        ImmersiveSpace(id: AppModel.objectTrackingSpaceID) {
            ObjectTrackingView()
                .environment(appModel)
        }
        .immersionStyle(selection: .constant(.mixed), in: .mixed)

        ImmersiveSpace(id: AppModel.coordinateConversionSpaceId) {
            CoordinateConversionImmersiveView()
                .environment(appModel)
        }
        .immersionStyle(selection: .constant(.mixed), in: .mixed)

        WindowGroup(id: AppModel.coordinateConversionWindowId) {
            CoordinateConversionVolumeView()
                .environment(appModel)
        }
        .windowStyle(.volumetric)

        WindowGroup(id: AppModel.lowLevelMeshWindowId) {
            LowLevelMeshView()
                .environment(appModel)
        }
    }
}
