#include <metal_stdlib>
using namespace metal;

struct VertexPositionColor {
    float3 position;
    float4 color;
};

struct MeshParams {
    int64_t meshResolution;
    float meshSize;
    float timerPhase;
    float4 color;
};

kernel void updateMeshKernel(device VertexPositionColor* vertices [[buffer(0)]],
                             constant MeshParams& params [[buffer(1)]],
                             uint id [[thread_position_in_grid]])
{
    float x = id % (params.meshResolution);
    float y = id / (params.meshResolution);

    float xPos = x / (params.meshResolution - 1) * params.meshSize - params.meshSize / 2.0;
    float yPos = y / (params.meshResolution - 1) * params.meshSize - params.meshSize / 2.0;

    float3 position;
    position.x = xPos + sin(y * 0.1 + params.timerPhase) / 100 * 0.5;
    position.y = yPos + sin(x * 0.1 + params.timerPhase) / 100 * 0.5;
    position.z = 0;

    vertices[id].position = position;
    vertices[id].color = params.color;
}
