//
//  Heise Vision Pro
//  Copyright © 2024 Gero Gerber. All rights reserved.
//

import ARKit
import RealityKit
import SwiftUI

struct MainView: View {
    @Environment(AppModel.self) private var appModel
    @Environment(\.openWindow) private var openWindow

    var body: some View {
        VStack {
            ToggleImmersiveSpaceButton(labelText: "Object Tracking", immersiveSpaceId: AppModel.objectTrackingSpaceID)
                .disabled(ObjectTrackingProvider.isSupported == false)
            Button {
                openWindow(id: AppModel.directionalLightWindowId)
            } label: {
                Text("Directional Light + Shadow")
                    .frame(width: 300)
            }
            Button {
                openWindow(id: AppModel.spotLightWindowId)
            } label: {
                Text("Spotlight + Shadow")
                    .frame(width: 300)
            }
            ToggleImmersiveSpaceButton(labelText: "Coordinate Conversion", immersiveSpaceId: AppModel.coordinateConversionSpaceId)
            Button {
                openWindow(id: AppModel.lowLevelMeshWindowId)
            } label: {
                Text("LowLevelMesh")
                    .frame(width: 300)
            }
            .padding(.bottom, 50)
            VStack {
                Text("Developed by")
                    .font(.caption)
                Link(destination: URL(string: "https://www.apptects.de")!) {
                    Image(.apptects)
                        .resizable()
                        .scaledToFit()
                        .frame(width: 100)
                        .clipShape(RoundedRectangle(cornerRadius: 10))
                }
            }
        }
        .padding(70)
        .frame(minWidth: 500, minHeight: 600)
    }
}

#Preview(windowStyle: .automatic) {
    MainView()
        .environment(AppModel())
}
