struct TeaTests {
    struct DescriptionTests {
        @Test(arguments: zip(
            [Tea.black, Tea.green, Tea.rooibos, Tea.herbal, Tea.fruit],
            ["Schwarzer Tee", "Grüner Tee", "Rooibos Tee", "Kräutertee", "Früchtetee"]
        ))
        func name(tea: Tea, name: String) {
            #expect(tea.name == name)
        }
    }
    
    struct DurationTests {
        @Test func hasDurationRangeForBlackTea() {
            let blackTea = Tea.black
            #expect(blackTea.durationInMinutesRange != nil)
        }
        
        @Test func hasDurationRangeForGreenTea() {
            let greenTea = Tea.green
            #expect(greenTea.durationInMinutesRange != nil)
        }
        
        @Test("Duration support", arguments: [Tea.black, Tea.green]) func hasDurationRange(for tea: Tea) {
            #expect(tea.durationInMinutesRange != nil)
        }
        
        @Test func hasNoDurationRangeForFruitTea() {
            let fruitTea = Tea.fruit
            #expect(fruitTea.durationInMinutesRange == nil)
        }
        
        @Test("No duration support", arguments: [Tea.rooibos, Tea.herbal, Tea.fruit]) func hasNoDurationRange(for tea: Tea) {
            #expect(tea.durationInMinutesRange == nil)
        }
    }
}