# llm.swift

Das Verzeichnis enthält das [GitHub-Repository](https://github.com/otabuzzman/llm.swift/releases/tag/v1.2.12) mit dem Quellcode der App zum Developer's Corner Artikel _Von CPU zu GPU: Code parallelisieren mit Metal_ im Apple Magazin [Mac & i Heft 3/ 2025](https://www.heise.de/select/mac-and-i/2025/3/). Die App ist eine Portierung der Codebase [llm.c](https://github.com/karpathy/llm.c) von Andrej Karpathy von C/ CUDA nach Swift/ Metal.

### Gebrauch

Das Repository enthält Tags mit Versionen für CPU und GPU:

- Tag v1.0.2 : CPU-Version
- Tag v1.1.0 : GPU-Version naiv (1:1 Port der CPU-Version von C nach Metal)
- Tag v1.2.12 : GPU-Version optimiert

```bash
# Webarchiv entpacken und ins Projektverzeichnis wechseln
cd llm.swift

# Modellparameter von Hugging Face holen
make checkpoint

# CPU-Version auschecken
git checkout v1.0.2

# Testprogramm kompilieren...
xcodebuild -scheme llm.swift -configuration Release \
  SWIFT_ACTIVE_COMPILATION_CONDITIONS="$SWIFT_ACTIVE_COMPILATION_CONDITIONS LLMDOTSWIFT_STANDALONE"

# ...und ausführen (schreibt viele Informationen nach stdout).
./test_gpt2

# Nur die Dauer der Inferenz ausgeben
./test_gpt2 | grep "forward layers took"

# Naiven Port der GPU-Version auschecken
git checkout v1.1.0

# Kompilieren und Inferenzdauer wie oben
xcodebuild -scheme llm.swift -configuration Release

./test_gpt2 | grep "forward layers took"

# Optimierten Port der GPU-Version auschecken
git checkout v1.2.12

# Kompilieren und Inferenzdauer wie oben
xcodebuild -scheme llm.swift -configuration Release

./test_gpt2 | grep "forward layers took"
```
