#!/bin/sh

# Ins Arbeitsverzeichnis wechseln.
mkdir MehrAlsWorte
cd MehrAlsWorte

# Virtuelle Umgebung für Python erstellen...
python3 –m venv .venv

# ...und aktiveren.
source .venv/bin/activate

# Python-Pakete zum Programmieren mit Hugging Face und Apples Stable
# Diffusion installieren...
pip3 install huggingface_hub
pip3 install git+https://github.com/apple/ml-stable-diffusion

# ...und Checkpoints für Stable Diffusion herunterladen.
python3 <<-EOF
from huggingface_hub import snapshot_download
from pathlib import Path
repo_id = "apple/coreml-stable-diffusion-v1-4"
variant = "original/packages"
model_path = Path("./models") / (repo_id.split("/")[-1] + "_" +
variant.replace("/", "_"))
snapshot_download(
repo_id, allow_patterns=f"{variant}/*",
local_dir=model_path,
local_dir_use_symlinks=False)
EOF

