#!/bin/sh

# Für Core ML kompilierte Checkpoints herunterladen...
python3 <<-EOF
from huggingface_hub import snapshot_download
from pathlib import Path
repo_id = "apple/coreml-stable-diffusion-v1-4"
variant = "original/compiled
model_path = Path("./models") / (repo_id.split("/")[-1] + "_" +
variant.replace("/", "_"))
snapshot_download(
repo_id, allow_patterns=f"{variant}/*",
local_dir=model_path,
local_dir_use_symlinks=False)
EOF

# ...und aufgrund eines Fehlers in der Swift-Konfiguration verschieben.
mv \
models/models/coreml-stable-diffusion-1-4_original_packages/original/compiled/* \
Models/models/coreml-stable-diffusion-1-4_original_packages

# Apples Repository clonen und ins Verzeichnis wechseln.
git clone https://github.com/apple/ml-stable-diffusion
cd ml-stable-diffusion

# Kommandozeilenversion des Beispiels für Swift kompilieren und ausführen.
swift run StableDiffusionSample \
--resource-path ../models/coreml-stable-diffusion-v1-4_original_compiled \
--compute-units cpuAndGPU "Maus mit Hoodie und Jeans auf Fahrrad"

