import FoundationModels
import Playgrounds

#Playground {
    let availability = SystemLanguageModel.default.availability

    switch availability {
        case .available:
            print("All good!")
        case .unavailable(let reason):
            switch reason {
                case .appleIntelligenceNotEnabled:
                    print("Apple Intelligence is not enabled. Enable in Settings")
                case .deviceNotEligible:
                    print("Language model not supported on this device")
                case .modelNotReady:
                    print("Language model is not ready yet. Please try again later")
                @unknown default:
                    print("Language model is unavailable for an unknown reason")
            }
        }
}

