import Foundation
import FoundationModels
import Playgrounds

#Playground {
    var jokeGeneratorSchema = DynamicGenerationSchema(name: "JokeGenerator",
                                                      properties: [
                                                        .init(name: "topic", schema: .init(type: String.self)),
                                                        .init(name: "jokes", schema: .init(arrayOf: .init(referenceTo: "JokeEntry")))
                                                      ])
    
    var jokeSchema = DynamicGenerationSchema(name: "JokeEntry",
                                             properties: [
                                                .init(name: "joke", schema: .init(type: String.self))
                                             ])

    let jokeGenerationSchema = try GenerationSchema(root: jokeGeneratorSchema, dependencies: [jokeSchema])
    
    let session = LanguageModelSession()
    let response = try await session.respond(to: "Tell jokes about math", schema: jokeGenerationSchema)

    let topic = try response.content.value(String.self, forProperty: "topic")
    let jokes = try response.content.value([GeneratedContent].self, forProperty: "jokes")
}
