import FoundationModels
import Playgrounds

@Generable(description: "Simple joke container")
fileprivate struct Joke {
    @Guide(description: "Contains the generated joke")
    var jokeText: String
}

@Generable(description: "Collection of jokes")
fileprivate struct JokeCollection {
    var jokes: [Joke]
}

#Playground {
    do {
        let stream = LanguageModelSession().streamResponse(to: "Generate jokes", generating: JokeCollection.self)
        
        for try await partial in stream {
            print(partial.content)
        }

    } catch {
        print(error)
    }
}
