import Foundation
import FoundationModels
import Playgrounds

@Generable(description: "Simple joke container")
fileprivate struct Joke {
    @Guide(description: "Contains the generated joke")
    var jokeText: String
}

@Generable(description: "Collection of jokes")
fileprivate struct JokeCollection {
    var jokes: [Joke]
}

fileprivate struct GetJokeTool: Tool {
    let name = "getJoke"
    let description = "Retrieve jokes by a keyword"
    
    @Generable
    struct Arguments {
        @Guide(description: "Keyword to search for jokes")
        var keyword: String
    }
    
    struct JokeResponse: Decodable {
        let joke: String?
    }
    
    enum GetJokeToolError: Error {
        case noJoke
    }
    
    func call(arguments: Arguments) async throws -> String {
        let url = URL(string: "http://v2.jokeapi.dev/joke/Any?type=single?contains=\(arguments.keyword)")!
        let (data, _) = try await URLSession.shared.data(from: url)
        let jokeResponse = try JSONDecoder().decode(JokeResponse.self, from: data)
        if let joke = jokeResponse.joke {
            return joke
        } else {
            throw GetJokeToolError.noJoke
        }
    }
}

#Playground {
    do {
        let jokeCollection = try await LanguageModelSession(tools: [GetJokeTool()]).respond(to: "Generate jokes for me about beer", generating: JokeCollection.self)
        
    } catch {
        print(error)
    }
}
