import FoundationModels
import Playgrounds

@Generable(description: "Item name and power")
fileprivate enum ItemType {
    case sword(String, Int)
    case knife(String, Int)
    case potion(String, Int)
}

@Generable(description: "In-game item for a role playing game")
fileprivate struct GameItem {
    @Guide(description: "Type of the item")
    let itemType: ItemType
    @Guide(description: "Condition of the item", .anyOf(["Good", "Used", "Broken"]))
    let condition: String
    @Guide(description: "Value of the item")
    let value: Int
    @Guide(description: "Magical effects the item has", .maximumCount(4))
    let effects: [String]
}

#Playground {
    do {
        try await LanguageModelSession().respond(to: "Generate a game item for my role-playing game", generating: GameItem.self)
    } catch {
        print(error)
    }
}
