' ****************************************************************
' Funktion:      Sichert gedroppte Dateien oder Ordner in einer
'                tglich neu angelegten ZIP-Datei.
'                (Korrigierte Version November 2004)
'
' Erfordert:    - Windows Scripting Host 2.0
'               - DlgTools.ocx
'               - Archivprogramm WinZIP ab Version 7.0
'
' Copyright (C) 2001 Ralf Nebelo
' ****************************************************************

Option Explicit

Dim objShell
Dim objFS
Dim strWinZipPfad
Dim strRegKey
Dim strBackupOrdner
Dim objDlgTools
Dim strZieldatei
Dim strQuelldatei
Dim intI
Dim intCounter
Dim intErrCode


On Error Resume Next

Set objShell = Wscript.CreateObject("WScript.Shell")
Set objFS = WScript.CreateObject("Scripting.FileSystemObject")

If Wscript.Arguments.Count = 0 Then
    MsgBox "Keine Dateien oder Ordner gedroppt.", vbInformation, Wscript.ScriptName
    WScript.Quit
End If

strWinZipPfad = objShell.RegRead("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\winzip32.exe\")
If strWinZipPfad = "" Then
    MsgBox "WinZip ist nicht installiert.", vbCritical, Wscript.ScriptName
    WScript.Quit
End If

strRegKey = "HKCU\Software\DesktopSkripte\BackupOrdner"
strBackupOrdner = objShell.RegRead(strRegKey)
If objFS.FolderExists(strBackupOrdner) = False Then
    Set objDlgTools = WScript.CreateObject("DesktopSkripte.DlgTools")
    If objDlgTools Is Nothing Then
        MsgBox "DlgTools.ocx ist nicht installiert.", vbInformation, Wscript.ScriptName
        WScript.Quit
    End If

    strBackupOrdner = objDlgTools.DlgOpenFolder("Bitte whlen Sie den Sicherungsordner:")
    If objFS.FolderExists(strBackupOrdner) = True Then
        objShell.RegWrite strRegKey, strBackupOrdner
    Else
        MsgBox "Kein gltiger Sicherungsordner.", vbCritical, Wscript.ScriptName
        WScript.Quit
    End If
End If

If Right(strBackupOrdner, 1) <> "\" Then
    strBackupOrdner = strBackupOrdner & "\"
End If

strZieldatei = Chr(34) & strBackupOrdner & Right(Date, 2) & "-" & Mid(Date, 4, 2) & "-" & Left(Date, 2) & ".zip" & Chr(34)

For intI = 0 To Wscript.Arguments.Count - 1
    strQuelldatei = Chr(34) & Wscript.Arguments(intI) & Chr(34)
    intErrCode = objShell.Run(strWinZipPfad & " -min -a " & strZieldatei & " " & strQuelldatei, 1, True)
    If intErrCode <> 0 Then
        MsgBox "WinZip-Fehler " & CStr(intErrCode) & " aufgetreten.", vbCritical, Wscript.ScriptName
        WScript.Quit
    Else
        intCounter = intCounter + 1
    End If
Next

MsgBox CStr(intCounter) & " Datei(en) oder Ordner in " & strZieldatei & " gesichert.", vbInformation, Wscript.ScriptName
