// ==UserScript==
// @name          WetterKarte
// @namespace     http://www.heise.de/ct
// @description   Kombiniert Wetterkarten des DWD und von WetterOnline
// @include       http://www.dwd.de/bvbw/appmanager/bvbw/*
// ==/UserScript==

(function (){
try{
  if (self.location.href!=top.location.href || !document.body)
    return;
}catch(e){
  return;
}

for (var i = 0; i < document.getElementsByTagName("h1").length; i++) {
  if (document.getElementsByTagName("h1")[i].className == "headline"
      && document.getElementsByTagName("h1")[i].textContent == "Radarbild") {

    // Schwebendes Fenster für Europa-Radar
    var EuroRadar_win = document.createElement('div');
    EuroRadar_win.id = 'EuroRadar_win';
    with(EuroRadar_win.style) {
      /* Mögliche Style-Eigenschaften: http://de.selfhtml.org/javascript/objekte/style.htm#style_eigenschaften */
      MozBorderRadius = '6px';
      border     = '2px solid gray';
      background = '#ced5e9';
      position   = 'absolute';
      top = '250px';
      right = '15px';
      width = '310px'
      height = '340px';
      padding = '2px 8px 2px 8px'
      display = 'block';
      textAlign = 'center';
    }
    document.body.appendChild(EuroRadar_win);

    /* Titelzeile */
    var tobj = document.createElement('h3');
    tobj.id = 'EuroRadar_title';
    tobj.textContent = 'Regenradar Europa';
    with(tobj.style) {
      color = 'black';
      fontSize = '12px';
      marginTop = '1px';
      marginBottom = '1px';
      opacity = '1.0';
      textAlign = 'center';
    }
    EuroRadar_win.appendChild(tobj);

    /* Unterzeile */
    tobj = document.createElement('h4');
    tobj.id = 'EuroRadar_subtitle';
    tobj.textContent = 'von WetterOnline';
    with(tobj.style) {
      color = 'black';
      fontSize = '10px';
      marginTop = '0px';
      marginBottom = '1px';
      opacity = '1.0';
      textAlign = 'center';
    }
    EuroRadar_win.appendChild(tobj);

    /* Link auf Europa-Radar-Seite bei WetterOnline */
    tobj = document.createElement('a');
    tobj.id = 'EuroRadar_link';
    tobj.href = 'http://www.wetteronline.de/euroradf.htm'
    tobj.target = '_new';
    EuroRadar_win.appendChild(tobj);

    /* Radarbild */
    tobj = document.createElement('img');
    tobj.id = 'EuroRadar_image';
    tobj.width = "300";
    tobj.height = "300";
    document.getElementById("EuroRadar_link").appendChild(tobj);

    GM_xmlhttpRequest({
      method:"GET",
      url:"http://www.wetteronline.de/daten/radarhtml/de/eurg/radarf.htm",
      onload:function(response) {
        /* URL des Radarbilds aus der HTML-Seite gewinnen */
        var MapUrl = response.responseText.match(/<img[^>]*src=\"\/daten\/radar\/eurg\/[2-9][0-9][0-9][0-9]\/[0-1][0-9]\/[0-3][0-9]\/[^>]*>/);
        MapUrl = MapUrl[0].match(/\/daten\/radar\/eurg\/[2-9][0-9][0-9][0-9]\/[0-1][0-9]\/[0-3][0-9]\/[^\.]*\.gif/);
        if(MapUrl[0].length > 0) {
          document.getElementById("EuroRadar_image").src = 'http://www.wetteronline.de' + MapUrl[0];
        }
      }
    });
  }

}

})();
