#include "FastLED.h"

// How many leds in your strip?
#define NUM_LEDS 60

// For led chips like Neopixels, which have a data line, ground, and power, you just
// need to define DATA_PIN.  For led chipsets that are SPI based (four wires - data, clock,
// ground, and power), like the LPD8806, define both DATA_PIN and CLOCK_PIN
#define DATA_PIN 3
#define CLOCK_PIN 13
char bytes[3] = {0, 0, 0};

// Define the array of leds
CRGB leds[NUM_LEDS];

void setup() { 
FastLED.addLeds<NEOPIXEL, DATA_PIN>(leds, NUM_LEDS);
fill_solid( &(leds[0]), NUM_LEDS, CRGB(0, 0, 0) );
for (int x = 0; x < NUM_LEDS; x++) leds[x] = CRGB(255,255,255); //Schwarz
FastLED.show();
Serial.begin(9600);
delay(1000);
}

void loop() { 

if (Serial.available() == 3) {
  Serial.readBytes(bytes, 3);
  for (int x = 0; x < NUM_LEDS; x++) leds[x] = CRGB(0, 50, 0);
  if (bytes[0] < NUM_LEDS) leds[bytes[0]] = CRGB(255, 0, 0);
  FastLED.show();
  }
}

