﻿# Eine .NET-Klasse mit der SendMessage-Funktion als statischem Member bauen
$source = @"
using System;
using System.Runtime.InteropServices;
public class Win32Helper
{
  [DllImport("user32.dll")]
  public static extern int SendMessage(IntPtr hWnd, UInt32 Msg, IntPtr wParam, IntPtr lParam);
}
"@
Add-Type -TypeDefinition $source

# Wenn der Rechner gerade erst aufgewacht ist, nichts tun
Start-Sleep -Seconds 1 # Warten auf Event-Log; auf langsamen Rechnern evtl. etwas verlängern
$wakeEvent = Get-WinEvent -LogName System -FilterXPath "Event[System[EventID=1 and Provider[@Name='Microsoft-Windows-Power-Troubleshooter']]]" -MaxEvents 1
$wakeTime = $wakeEvent.TimeCreated
if( ((Get-Date) - $wakeTime).TotalSeconds -lt 5 ) {
    return
}

# Konstanten für den Aufruf definieren
$HWND_BROADCAST = 0xffff
$WM_SYSCOMMAND = 0x0112
$SC_MONITORPOWER = 0xf170
$MONITOR_ON = -1
$MONITOR_STANDBY = 1
$MONITOR_OFF = 2

# ... und die Funktion aufrufen
[Win32Helper]::SendMessage($HWND_BROADCAST, $WM_SYSCOMMAND, $SC_MONITORPOWER, $MONITOR_OFF) | Out-Null
