#!/bin/bash
# configure nfs on controller
ssh oslcontroller <<EOF
# configure cinder to use nfs share on oslcontroller
cat <<END > /etc/cinder/nfs_shares
oslcontroller_mem:/srv/node/cinder-nfs
END
chown root:cinder /etc/cinder/nfs_shares
chmod 0640 /etc/cinder/nfs_shares
cat <<END >> /etc/cinder/cinder.conf

[nfs]
nfs_shares_config = /etc/cinder/nfs_shares
volume_driver = cinder.volume.drivers.nfs.NfsDriver
volume_backend_name = nfsbackend
#nfs_mount_options = MOUNTOPTIONS
END
sed -i -e "s/\(enabled_backends\s*=\s*\)lvm/\1nfs/" /etc/cinder/cinder.conf
# open Firewall
iptables -I INPUT -s 192.168.127.0/24 -m state --state NEW -p tcp --dport 2049 -j ACCEPT
iptables -I INPUT -s 192.168.127.0/24 -m state --state NEW -p tcp --dport 111 -j ACCEPT
sed -i -e "s/^\(-A INPUT -j nova-api-INPUT\)\$/\1\n-A INPUT -s 192.168.127.0\/24 -m state --state NEW -p tcp --dport 2049 -j ACCEPT\n-A INPUT -s 192.168.127.0\/24 -m state --state NEW -p tcp --dport 111 -j ACCEPT/" /etc/sysconfig/iptables
openstack-service restart cinder-volume
mount | grep cinder
source keystonerc_admin
cinder type-create nfstype
cinder type-key nfstype set volume_backend_name=nfsbackend
cinder type-delete \`cinder type-list|grep iscsi|cut -d\| -f2\`
EOF
