package com.linkesoft.relax;

import android.app.Activity;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.widget.MediaController;
import android.widget.Toast;
import android.widget.VideoView;

/**
 * Zeige Video bildschirmfüllend an und spiele es endlos ab
 */
public class VideoActivity extends Activity {

    final static String ID="id";
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_video);

        VideoView videoView =(VideoView)findViewById(R.id.videoView);
        // Ressource-ID des Videos
        String id=getIntent().getStringExtra(ID);
        // Uri zum Video
        Uri uri= Uri.parse("android.resource://"+getPackageName()+"/"+id);
        videoView.setVideoURI(uri);

        // Steuerung über MediaController (Klick auf OK) falls gewünscht
        MediaController mediaController= new MediaController(this);
        mediaController.setAnchorView(videoView);
        videoView.setMediaController(mediaController);

		// Zugriff auf internen MediaPlayer um das Video endlos abzuspielen
		videoView.setOnPreparedListener (new MediaPlayer.OnPreparedListener() {
			@Override
			public void onPrepared(MediaPlayer mp) {
                mp.setLooping(true);
			}
		});

        // Fehlerbehandlung
        videoView.setOnErrorListener(new MediaPlayer.OnErrorListener() {
            @Override
            public boolean onError(MediaPlayer mp, int what, int extra) {
                // Video konnte nicht abgespielt werden (z.B. im Emulator)
                Toast.makeText(VideoActivity.this, "Video konnte leider nicht abgespielt werden, bitte versuchen Sie es auf einem anderen Gerät.",Toast.LENGTH_LONG).show();
                finish(); // beende Activity
                return true; // Fehler wurde behandelt
            }
        });

        videoView.start();
    }
}
