# Installation

Der Quellcode ist in Go geschrieben und verwendet das Buildtool "gb".
Dies hat den Vorteil, das alle notwendigen Bibliotheken als lokale Kopie
vorgehalten werden können (Vendoring). Die Installation ist recht
einfach:

1. Zunächst muss Go installiert werden. Dazu folgt man einfach der
Anleitung unter https://golang.org/doc/install für das entsprechende
Betriebssystem.

2. Danach installiert man das Buildtool "gb" wie unter https://getgb.io/
beschrieben - im Allgemeinen sollte ein 

    $ go get github.com/constabulary/gb/...

genügen.

3. Jetzt kann das Projekt kompiliert werden. Dazu im gleichen
Verzeichnis wie diese README folgenden Befehl ausführen:

    $ gb build all

Damit werden alle Bibliotheken übersetzt und im Verzeichnis "bin" das
Programm als "heise-topnews" abgelegt. Diese Datei kann man nun mittels

    $ ./bin/heise-topnews

ausführen.

# Crosscompiling für andere Plattformen

Das Buildtool "gb" unterstützt auch das Crosscompiling: So kann man auf
einem Mac OS-Rechner ein Binary für ein Linux-System erstellen. Da Go
alle zur Laufzeit benötigten Bibliotheken statisch in das Binary linkt
genügt ein einfaches Kopieren, um das Programm auf einem anderen System
auszuführen. Um z.B. den Quellcode für einen Raspberry Pi zu übersetzen
geht man wie folgt vor:

    $ rm -rf pkg bin       # Alte Kompilate löschen
		$ GOOS=linux GOARCH=arm GOARM=5 gb build all

Das Kompilat kann einfach auf den Raspberry Pi kopiert werden. Es ist
direkt lauffähig. Eine Liste möglicher Kombinationen von Plattformen
listet die Go-Dokumentation unter
https://golang.org/doc/install/source#environment auf.
