Param([Switch]$Cleanup)

if($Cleanup) {
  # Aufrumen
  Get-CimInstance -Namespace root/subscription -Class __FilterToConsumerBinding |
    ? {$_.Filter.Name -eq 'ServiceFilter'} |
    Remove-CimInstance
  Get-CimInstance -Namespace root/subscription -Class LogFileEventConsumer -Filter 'Name = "ServiceLogger"' |
    Remove-CimInstance
  Get-CimInstance -Namespace root/subscription -Class __EventFilter -Filter 'Name ="ServiceFilter"' |
    Remove-CimInstance
  exit
}

### Hier beginnt das eigentliche Skript ###
$FilterArgs = @{
  EventNamespace = 'root/cimv2';
  Name = 'ServiceFilter';
  Query = 'select *
           from __InstanceModificationEvent
           within 3
           where TargetInstance isa "Win32_Service"
             and TargetInstance.Started <> PreviousInstance.Started';
  QueryLanguage = 'WQL'
}
$Filter = New-CimInstance -Namespace root/subscription `
  -ClassName __EventFilter -Property $FilterArgs

$ConsumerArgs = @{
  Name = 'ServiceLogger';
  Filename = 'C:\ServiceTest.log';
  Text = '%TIME_CREATED%: %TargetInstance.Name% -> %TargetInstance.State%'
}
$Consumer = New-CimInstance -Namespace root/subscription `
  -ClassName LogFileEventConsumer -Property $ConsumerArgs

$BindingArgs = @{
  Filter = [Ref] $Filter;
  Consumer = [Ref] $Consumer
}
$Binding = New-CimInstance -Namespace root/subscription `
  -ClassName __FilterToConsumerBinding -Property $BindingArgs
