﻿Param([Switch]$Cleanup)

if($Cleanup) {
  # Aufräumen
  Unregister-Event -SourceIdentifier SpaceWatch
  exit
}

### Hier beginnt das eigentliche Skript ###
function Global:RecoverDriveSpace($evt) {
  $Global:lastEvent = $evt

  $volume = $evt.SourceEventArgs.NewEvent.TargetInstance
  Write-Host "Aufräumen auf Laufwerk $($volume.DriveLetter) ..."
  Clear-RecycleBin -DriveLetter $volume.DriveLetter -Force
  # To Do: Andere Platzfresser löschen ...
}

$query = 'select *
  from __InstanceModificationEvent
  within 5
  where TargetInstance isa "Win32_Volume"
    and TargetInstance.DriveLetter = "C:"
    and TargetInstance.FreeSpace < 10000000000
    and PreviousInstance.FreeSpace >= 10000000000'
Register-CimIndicationEvent `
  -SourceIdentifier SpaceWatch `
  -Query $query `
  -Action { RecoverDriveSpace $event }
