
//////////////////////////////////////////////////////////////////////
//
// Zeichentabelle
//
//////////////////////////////////////////////////////////////////////

byte ASCII[][7]=
{ 
 {0,0,0,0,0,0,0},                   //Space ==>ASCII 32
 { 0 , 0 , 249 , 0 , 0  },          //  ! 
 {0 , 224 , 0 , 224 , 0},           //  "
 {0,80 ,248 ,80 ,248 , 80 ,0},      //  #
 {32 , 81 , 138 , 4 , 0},           //  $ (Dollar)
 {4 , 194 , 1 , 194 , 12},          //  % (Smilie)
 {108 , 146 , 170 , 68 , 10 },      //  §
 {0 , 160 , 192 , 0 , 0},           //  '
 {0 , 56 , 68 , 130 , 0},           //  (
 {0 , 130 , 68 , 56 , 0 },          //  )
 {40 , 16 , 124 , 16 , 40},         //  *
 {16 , 16 , 124 , 16 , 16},         //  +
 {0 , 10 , 12 , 0 , 0 },            //  ,  (Komma)
 { 16 , 16 , 16 , 16 , 16  },       //  -
 {0 , 0 , 6 , 6 , 0  },             //  .  (Punkt)
 {2 , 4 , 8 , 16 , 32},             //  /
  ////////////////////// Zahlen //////////////////////
  { 124 , 138 , 146 , 162 , 124 }, // 0  ==>ASCII 48
 { 0 , 66 , 254 , 2 , 0 },         // 1
 { 66 , 134 , 138 , 146 , 98  },   // 2
 { 132 , 130 , 162 , 210 , 140  }, // 3
 { 24 , 40 , 72 , 254 , 8 },       // 4
 { 228 , 162 , 162 , 162 , 156 },  // 5
 { 60 , 82 , 146 , 146 , 12 },     // 6
 { 128 , 142 , 144 , 160 , 192 },  // 7
 { 108 , 146 , 146 , 146 , 108 },  // 8
 { 96 , 146 , 146 , 148 , 120 },   // 9
////////////////////////////////////////////////////////
 {0 , 108 , 108 , 0 },            //  : ==ASCII 58
 {0 , 106 , 108 , 0 , 0 },        //  ;
 {0 , 16 , 40 , 68 , 130},         //  <
 {40 , 40 , 40 , 40 , 40},         //  =
 {130 , 68 , 40 , 16 , 0},         //  >
 { 64 , 128 , 138 , 144 , 96 },    //  ?
 {2 , 146 , 158 , 130 , 124},      //  @
 ////////////// Großbuchstaben //////////////////////
 {  126 , 136 , 136 , 136 , 126 },  // A  ==>ASCII 65
 {  254 , 146 , 146 , 146 , 108 },  // B
 {  124 , 130 , 130 , 130 , 68 },   // C
 {  254 , 130 , 130 , 68 , 56  },   // D
 {  254 , 146 , 146 , 146 , 130 },  // E
 {  254 , 144 , 144 , 144 , 128 },  // F
 {  124 , 130 , 146 , 146 , 94 },   // G
 {  254 , 16 , 16 , 16 , 254  },    // H
 {  0 , 130 , 254 , 130 , 0 },      // I
 {  4 , 2 , 130 , 252 , 128 },      // J
 {  254 , 16 , 40 , 68 , 130 },     // K
 {  254 , 2 , 2 , 2 , 2 , 0 },      // L
 {  254 , 64 , 48 , 64 , 254 },     // M
 {  254 , 32 , 16 , 8 , 254 },      // N
 {  124 , 130 , 130 , 130 , 124  }, // O
 {  254 , 144 , 144 , 144 , 96 },   // P
 {   124 , 130 , 138 , 132 , 122 }, // Q
 {  254 , 144 , 152 , 148 , 98  },  // R
 {  98 , 146 , 146 , 146 , 140  },  // S
 {  128 , 128 , 254 , 128 , 128  }, // T
 {  252 , 2 , 2 , 2 , 252 },       // U
 {  248 , 4 , 2 , 4 , 248 },        // V
 {  252 , 2 , 30 , 2 , 252 },       // W
 {  198 , 40 , 16 , 40 , 198 },     // X
 { 224 , 16 , 14 , 16 , 224  },     // Y
 { 134 , 138 , 146 , 162 , 194 },   // Z
///////////////////////////////////////////////////////
 {254 , 130 , 130 , 0 , 0},         //  [  ==> ASCII 91  `
 {64 , 32 , 16 , 8 , 4},            //  \
 {0 , 0 , 130 , 130 , 254},         //  [
 { 0 , 64 , 128 , 64 , 0},          //  ^
 {2 , 2 , 2 , 2 , 2 },              //  _
 { 0 , 128 , 64 , 0 , 0},           // `
  { 0 , 128 , 64 , 0 , 0},           // `

////////////// Kleinbuchstaben //////////////////////  
 {  4 , 42 , 42 , 42 , 30  },      // a  ==>ASCII 97
 {  254 , 18 , 34 , 34 , 28 },  // b
 { 28 , 34 , 34 , 34 , 4 },      // c
 { 28 , 34 , 34 , 18 , 254 },      // d
 { 28 , 42 , 42 , 42 , 24  },      // e
 {  16 , 126 , 144 , 128 , 64 },        // f
 {  48 , 74 , 74 , 74 , 124 },       // g
 {  254 , 16 , 32 , 32 , 30  },  // h
 {  0 , 34 , 190 , 2 , 0 },         // i
 {  4 , 2 , 34 , 188 , 0 },         // j
 {  254 , 8 , 20 , 34 , 0 },  // k
 {  0 , 130 , 254 , 2 , 0},        // l
 { 62 , 32 , 24 , 32 , 30 },      // m
 {  62 , 16 , 32 , 32 , 30 },      // n
 {  28 , 34 , 34 , 34 , 28 },      // o
 {  62 , 40 , 40 , 40 , 16 },      // p
 {  16 , 40 , 40 , 24 , 62},          // q
 {  62 , 16 , 32 , 32 , 16 },      // r
 { 18 , 42 , 42 , 42 , 4 },        // s
 {  32 , 252 , 34 , 2 , 4  },        // t
 {  60 , 2 , 2 , 4 , 62 },        // u
 { 56 , 4 , 2 , 4 , 56 },        // v
 { 60 , 2 , 12 , 2 , 60 },       // w
 { 34 , 20 , 8 , 20 , 34 },         // x
 {  48 , 10 , 10 , 10 , 60},        // y
 {  34 , 38 , 42 , 50 , 34 },         // z  ==ASCII 122
};

void set_char(char ch, byte register_nummer , byte pos)
{
  for (int i=0; i<5 ; i++)
  {
  byte_register[register_nummer][pos*7+i]=ASCII[ch-32][i];
  }
}


void write_string(String s, byte register_nummer , byte pos)
{
  for (int i=0; i<s.length();i++)
  {
   byte c=s[i] ;
   set_char(c, register_nummer, i+pos);
  
  }
}

void clear_register()
{
 for (int i = 0; i< anzahl_register ; i++)
  for ( int ii =0 ; ii < sectoren ; ii++) 
  byte_register[i][ii]=0;
}
