/* Ping))) Sensor
  
   This sketch reads a PING))) ultrasonic rangefinder and returns the
   distance to the closest object in range. To do this, it sends a pulse
   to the sensor to initiate a reading, then listens for a pulse 
   to return.  The length of the returning pulse is proportional to 
   the distance of the object from the sensor.
     
   The circuit:
	* +V connection of the PING))) attached to +5V
	* GND connection of the PING))) attached to ground
	* SIG connection of the PING))) attached to digital pin 7

   http://www.arduino.cc/en/Tutorial/Ping
   
   created 3 Nov 2008
   by David A. Mellis
   modified 30 Aug 2011
   by Tom Igoe
 
   This example code is in the public domain.

 */
#include <Servo.h> 

Servo servo1; 
Servo servo2;
Servo servo3;

// this constant won't change.  It's the pin number
// of the sensor's output:
int sonicSensor1 = 2;
int sonicSensor2 = 4;
int sonicSensor3 = 6;

Servo servo[3] = {servo1,servo2,servo3};
int sonicSensor[3] = {sonicSensor1,sonicSensor2,sonicSensor3};


void load(int servo_id){

  servo[servo_id].write(0);
  delay(300);
  servo[servo_id].write(120);
  
}
 
void fire(int servo_id){
  

  servo[servo_id].write(180); 
  delay(260);
  Serial.println("Fire");
  load(servo_id);

}


void setup() {
  // initialize serial communication:
  Serial.begin(9600);
  servo[0].attach(3);
  servo[1].attach(5);
  servo[2].attach(7);
  
  for(int i=0;i<3;i++){
   
    load(i);
  }

}


void analizeSonicSensor(int sensor_id){
  // establish variables for duration of the ping, 
  // and the distance result in inches and centimeters:
  long duration, inches, cm;

  // The PING))) is triggered by a HIGH pulse of 2 or more microseconds.
  // Give a short LOW pulse beforehand to ensure a clean HIGH pulse:
  pinMode(sonicSensor[sensor_id], OUTPUT);
  digitalWrite(sonicSensor[sensor_id], LOW);
  delayMicroseconds(2);
  digitalWrite(sonicSensor[sensor_id], HIGH);
  delayMicroseconds(5);
  digitalWrite(sonicSensor[sensor_id], LOW);

  // The same pin is used to read the signal from the PING))): a HIGH
  // pulse whose duration is the time (in microseconds) from the sending
  // of the ping to the reception of its echo off of an object.
  pinMode(sonicSensor[sensor_id], INPUT);
  duration = pulseIn(sonicSensor[sensor_id], HIGH);

  // convert the time into a distance
  inches = microsecondsToInches(duration);
  cm = microsecondsToCentimeters(duration);
  
  Serial.println("Sonic Sensor: "+String(sensor_id)+" Value: "+String(cm));
  if(cm < 10 && cm > 0){
    //load(sensor_id);
    fire(sensor_id);
  }
}


void loop()
{

  for(int i=0;i<3;i++){
   analizeSonicSensor(i);
  }
  delay(100);
}

long microsecondsToInches(long microseconds)
{
  // According to Parallax's datasheet for the PING))), there are
  // 73.746 microseconds per inch (i.e. sound travels at 1130 feet per
  // second).  This gives the distance travelled by the ping, outbound
  // and return, so we divide by 2 to get the distance of the obstacle.
  // See: http://www.parallax.com/dl/docs/prod/acc/28015-PING-v1.3.pdf
  return microseconds / 74 / 2;
}

long microsecondsToCentimeters(long microseconds)
{
  // The speed of sound is 340 m/s or 29 microseconds per centimeter.
  // The ping travels out and back, so to find the distance of the
  // object we take half of the distance travelled.
  return microseconds / 29 / 2;
}
