// Datum: 14.09.2016   L A B O R N E T Z T E I L
#include <EEPROM.h>
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
#define I2CADR 0x20 //0x20 Pollin, 0x27 alle anderen Displays
//                    I2C-ADR,EN,RW,RS,Bit#0 D4,Bit#1 D5,Bit#2 D6,Bit#3 D7 
LiquidCrystal_I2C lcd( I2CADR, 2, 1, 0,       4,       5,       6,       7);//,3, POSITIVE);
#include <AH_MCP41xxx.h> //für die Potisteuerung, Chip MCP42010
#define DATAOUT  11   //uno MOSI , IC SI,  am Chip Pin 3
#define SPICLOCK 13   //uno SCK  , IC SCK, am Chip Pin 2
#define CS   10   //chipselect pin,        am Chip Pin 1
#define SHDN 9   //shutdown pin
#define RS   8   //reset pin
AH_MCP41xxx mcp42010;
#define poti_0 0 //Strom
#define poti_1 1 //Spannung
float vref=5.00;  // Referenzspannung
float uaus=15.00; // max. Ausgangsspanung
boolean di_flanke[2]={LOW,LOW};
int tempopos[2]={0,0}, returnwert_old, di, spannung_soll=0, count1=0, count2=0, strom_max=5, strom_ist_null=1000, strom_soll_null=3; 
long spannung_ist, strom_ist;
unsigned long tempo[2][2], display_wdh, ti_sicherung=0, ti_kalibrierung=0, ti_speichertaste=0, dauer_sollv=0, dauer_solla=0;
boolean flanke_sicherung, flag_sicherung=false, blink=false,flanke_speichertaste=true,
          speichertaste_lang=false, flag_speichertaste=false;
#define taster_sicherung 2 //elektronische Sicherung einschalten oder ausschalten
#define speichertaste 3     //Schnelltaste, 5V, 50 mA
#define drehimpuls12 4     //Eingang Drehimpulsgeber Nr.1 Spannung
#define drehimpuls11 5     //Drehrichtung Impulsgeber Nr 1 Spannung
#define drehimpuls22 6     //Eingang Drehimpulsgeber Nr.2 Strom
#define drehimpuls21 7     //Drehrichtung Impulsgeber Nr 2 Strom
/**************************************************************************************/
void setup(){
  mcp42010.init_MCP42xxx (CS, SHDN, RS);  //initialisation
  spannung_soll=EEPROM.read(1);
  strom_max=EEPROM.read(2);
  mcp42010.setValue(strom_max, poti_0); //Strom auf letzten gespeicherten Wert
  mcp42010.setValue(spannung_soll, poti_1); //Spannung auf letzten gespeicherten Wert
  flag_sicherung=   EEPROM.read(0); //Sicherung an oder aus auf den letzten gespeicherten Wert
  strom_ist_null=   EEPROM.read(3)+EEPROM.read(4)*256; //Stromkalibrierungswert einlesen
  strom_soll_null=  EEPROM.read(5);
  //analogReference (EXTERNAL); //externe 5 Volt Referencespannung
  Serial.begin(115200); // Serielle Schnittstelle Start
  pinMode(taster_sicherung, INPUT);
  pinMode(speichertaste,     INPUT);
  pinMode(drehimpuls11,     INPUT);
  pinMode(drehimpuls12,     INPUT);
  pinMode(drehimpuls21,     INPUT);
  pinMode(drehimpuls22,     INPUT);
  //Serial.println("Labornetzteil,  Version 14.09.2016");
  lcd.begin(8,2);
  lcd.home();
  lcd.print(" Labor- ");
  lcd.setCursor(0,1); //1.Spalte, 2. Zeile
  lcd.print("Netzteil");
  delay(1000);
  lcd.setCursor(0,0);
  lcd.print("14.09.16");
  delay(1000);
  display_wdh=millis();
}
/***V O I D   L O O P *****************************************************************/
void loop(){
  sicherung(); //elektronische Sicherung 
  memory(); //Schnelleinstellung Speichertaste 
  spannungseinstellung(); //Spannungsabfrage 
  stromeinstellung();  
  anzeigeaktualisierung();
}
//***elektronische Sicherung *********************************************************
void sicherung() {
  if(digitalRead(taster_sicherung)==LOW) { //Taster ist gedrückt
    ti_sicherung=millis(); //Timer "aufziehen"
    if(flanke_sicherung==false) {
      ti_kalibrierung=millis();
      flanke_sicherung=true;
      if(flag_sicherung==false) flag_sicherung=true;
      else flag_sicherung=false;
      anzeige_soll(spannung_soll,strom_max,800);
    }
    else if((millis()-ti_kalibrierung) >10000) {//wird Taster_sicherung länger als 10 Sekunden gedrückt, Strom 0-Wert kalibrieren
      mcp42010.setValue(100, poti_0); //es darf keine Strombegrenzung eingeschaltet sein, 100 = sicherer Wert dafür
      lcd.setCursor(0,0);lcd.print("Kali-   ");lcd.setCursor(0,1);lcd.print("brirung "); delay(1000);     
      strom_ist_null=0;
      for(int n=0;n<5;n++) { //Mittelwert aus 5 gelesenen Werten bilden
        strom_ist_null=strom_ist_null+analogRead(1);
        //Serial.println(strom_ist_null/(n+1));
        delay(n);
      }
      strom_ist_null=strom_ist_null/5; 
      //lcd.setCursor(0,0);lcd.print("istSTROM");lcd.setCursor(0,1);lcd.print("        ");lcd.setCursor(0,1);lcd.print(strom_ist_null); delay(5000);     
      EEPROM.write(3,strom_ist_null%256); //Low-Byte
      EEPROM.write(4,strom_ist_null/256);//High-Byte, Kalibrierung des zu messenden Stromes abgeschlossen
      int n=100;
      while(!strombegrenzung()) {
        mcp42010.setValue(byte(n), poti_0);
        n--;
        delay(20);
      }
      strom_soll_null=n+1;
      //lcd.setCursor(0,0);lcd.print("solSTROM");lcd.setCursor(0,1);lcd.print("        ");lcd.setCursor(0,1);lcd.print(strom_soll_null); delay(5000);
      EEPROM.write(5,strom_soll_null); //Kalibrierung des eingestellten Stromes abgeschlossen
   }
 }
 if(digitalRead(taster_sicherung)==HIGH&&(millis()-ti_sicherung)>100) flanke_sicherung=false;
 if(flag_sicherung==true) { //Sicherung ist eingeschaltet
   if(strombegrenzung()) { //Strombegrenzung ist aktiv geworden, Sicherung hat ausgelöst, Spannung auf 0Volt schalten
     strom_max=strom_soll_null;
     spannung_soll=0;
     //Serial.println("Sicherung hat ausgelöst");   
     mcp42010.setValue(byte (strom_max), poti_0); //Poti0=Strom auf max. 0mA
     mcp42010.setValue(byte (spannung_soll), poti_1);
     //anzeige_soll(spannung_soll,strom_max,800);     
      }
    }
}
//***Schnelleinstellung Speichertaste **************************************
void memory(){
// kurz gedrückt: abrufen der gespeicherten Spannung, Strom, Sicherungseinstellung,lange gedrückt: Speichern im EEPROM
  if(digitalRead(speichertaste)==LOW) {
    if(flanke_speichertaste ==true) {
      flanke_speichertaste=false;
      ti_speichertaste=millis();
    }
    if(flanke_speichertaste==false) {
      if((millis()-ti_speichertaste)>3000) {
        lcd.setCursor(0,0);
        lcd.print(" EEPROM ");
        lcd.setCursor(0,1);
        lcd.print("Speicher");
        delay(2000);
        EEPROM.write(0,flag_sicherung);
        EEPROM.write(1,spannung_soll);
        EEPROM.write(2,strom_max);
      }
      if(ti_speichertaste>100) {
        lcd.setCursor(5,0);
        lcd.write('v'); 
        lcd.setCursor(5,1);
        lcd.write('a'); 
     }
    }
  }
  else {
    if((millis()-ti_speichertaste)>100&&flanke_speichertaste==false) {
      flanke_speichertaste=true;
      flag_sicherung=EEPROM.read(0);
      spannung_soll=EEPROM.read(1);
      strom_max=EEPROM.read(2);
      mcp42010.setValue(byte (spannung_soll), poti_1);
      mcp42010.setValue(byte (strom_max), poti_0);
      anzeige_soll(spannung_soll,strom_max,800);
    }
  }
}
//***Spannungsabfrage ******************************************************
void spannungseinstellung() {
  di=drehimp(0); //0=kein Impuls, 1=langsam CW, 2=schnell CW, 3=langsam CCW, 4=schnell CCW
  if(di!=0) {
    if(spannung_soll<255&&di==1) spannung_soll++;
    if(spannung_soll<251&&di==2) spannung_soll=spannung_soll+5;
    if(spannung_soll>0  &&di==3) spannung_soll--;
    if(spannung_soll>4  &&di==4) spannung_soll=spannung_soll-5;
    mcp42010.setValue(byte (spannung_soll), poti_1); //Poti1 für Spannung
    //anzeige_soll(spannung_soll,strom_max,150);
    dauer_sollv=millis();
    anzeige(1);
  }
}
//***Stromabfrage ************************************************************
void stromeinstellung() {
  di=drehimp(1); //0=kein Impuls, 1=langsam CW, 2=schnell CW, 3=langsam CCW, 4=schnell CCW
  if(di!=0) {
    if(strom_max<254&&di==1)                strom_max++; //entspricht Strombegrenzung auf 2A
    if(strom_max<250&&di==2)                strom_max=strom_max+5;
    if(strom_max>strom_soll_null&&di==3)     strom_max--; // nicht auf Null da auch der ArduinoProzessor und das Display Strom zieht
    if(strom_max>(strom_soll_null+4)&&di==4) strom_max=strom_max-5;
    mcp42010.setValue(byte (strom_max), poti_0); //Poti0=Strom
    //anzeige_soll(spannung_soll,strom_max,150);
    dauer_solla=millis();
    anzeige(1);
  }
}
//***  Anzeigeaktualisierung **************************************************
void anzeigeaktualisierung(){
  if((millis()-display_wdh)>750&&(millis()-display_wdh)<30000) { //alle 750ms neu ausgeben, <30000 da in Anzeige soll getrixt wird mit display_wdh
    display_wdh=millis();
    anzeige(5);
  }
}    
//***Display mit Ist-Werten aktualisieren *************************************
void anzeige(int mw){
  float volt_ist, volt_soll, ampere_ist, ampere_soll;
      spannung_ist=0;
      strom_ist=0;
      for(int n=0;n<mw;n++) { //damit das Display nicht flackert wird ein Mittelwert gebildet
        spannung_ist=spannung_ist+analogRead(0);
        strom_ist=strom_ist+analogRead(1);
        delay(n);
      }
      spannung_ist=spannung_ist/mw;
      strom_ist=strom_ist/mw; 
      volt_ist =float (spannung_ist) *15.0/1024.0+0.02;//Umrechnung des gelesenen Analogwertes in Volt
      volt_soll=float (spannung_soll) *15.0/255.0;//Umrechnung des eingestellten Analogwertes in Volt
      if(strom_ist > strom_ist_null ) strom_ist=strom_ist_null; //verhindert ein Minuszeichen bei Leerlauf in der Anzeige
      ampere_ist =(float (strom_ist_null-strom_ist))*2.2570/1000.0;//Umrechnung des gelesenen Analogwertes in Ampere
      ampere_soll=float(strom_max-strom_soll_null)/157.5;//Umrechnung des eingestellten Analogwertes in Ampere     
//    Serial.print("ist:");Serial.print(/*strom_ist_null-*/strom_ist);Serial.print("   strom_soll_null:");Serial.print(strom_soll_null); Serial.print("   max-strom_soll_null:");Serial.print(strom_max-strom_soll_null);Serial.print(" analogRead(2): ");Serial.println(analogRead(2));
      lcd.setCursor(0,0); // 1.Zeile = Spannungsanzeige
      if(strombegrenzung()&& (millis()-dauer_sollv)<1000) {//wenn Soll_Spannung neu eingestellt wurde, für 1 Sekunde anzeigen
        if(volt_soll<10.0) lcd.print(" "); // Spannung einstellig, also führendes Blank
         lcd.print(volt_soll,2);
         lcd.print("Vs "); 
      }
      else { //die über den Analogeingang gemessene Ist-Spannung anzeigen
        if(volt_ist<10.0) lcd.print(" "); // ist-Spannung <10V
        lcd.print(volt_ist,2);
        lcd.print("V  ");
      }
      lcd.setCursor(0,1); // 2.Zeile = Stromanzeige
      if(flag_sicherung==true) { //wenn Sicherung eingeschaltet ist, in der 1. Spalte der 2. Zeile Schmierzeichen anzeigen
        if(strom_max>strom_soll_null||(strom_max==strom_soll_null&&blink==false)) {
          lcd.write(0xFF);
          blink=true;
        }
        else {
          blink=false;
          lcd.print(" ");
        }
      }
      else lcd.print(" ");
      if(!strombegrenzung()&& (millis()-dauer_solla)<1000) {//wenn Soll_Strom neu eingestellt wurde, für 1 Sekunde anzeigen
        lcd.print(ampere_soll,2);
        lcd.print("As "); 
      }
      else {
        lcd.print(ampere_ist,2); //den über den Analogeingang gemessene Ist-Strom anzeigen
        lcd.print("A  ");
      }
      if(strombegrenzung()) { //Strombegrenzung ist aktiv geworden
        lcd.setCursor(7,1);
        lcd.write(0xFF);
        lcd.setCursor(7,0);
        lcd.write(0x20); 
      }
      else {
        lcd.setCursor(7,0);
        lcd.write(0xFF);
        lcd.setCursor(7,1);
        lcd.write(0x20);  
      }
}
/*** Anzeige der Soll-Werte ***********************************************************/
void anzeige_soll(int spannung_soll,int strom__max, int anzeigedauer) {
  lcd.setCursor(0,0);
  if(spannung_soll<170) lcd.print(" "); // Spannung einstellig, also führendes Blank
  lcd.print(float(float(spannung_soll)*float(15.0/255.0)),2);
  lcd.print("Vs ");
  lcd.setCursor(1,1);
  //lcd.print(" ");
  lcd.print(float(float(strom__max-strom_soll_null)*float(2047.0/230000.0)),2);//-5 weil auch der Arduino und das Display Strom zieht
  lcd.print("As ");
  display_wdh=millis()+anzeigedauer; //mindestens für 1,5 Sekunden anzeigen
}
/*** Drehimpulsgeber ******************************************************************/
int drehimp(int dig) { //in dig steht welcher Drehimpulsgeber abgefragt wird (Spannung oder Strom)
  int dip0=drehimpuls11, dip1=drehimpuls12, tempoflag, returnwert;
  if(dig!=0) {
     dip0=drehimpuls21;
     dip1=drehimpuls22;
  }
  if(digitalRead(dip0)==HIGH) di_flanke[dig]=false;
  else {
    if(di_flanke[dig]==false) { //Flanke erkannt, derzeit ohne entprellen
      di_flanke[dig]=true;
      tempo[dig][tempopos[dig]]=millis(); 
      if(tempo[dig][tempopos[dig]] - (tempo[dig][tempopos[dig]^1]) > 80) 
           tempoflag=0; //Mehr als 80 Millisekunden seit dem letzten Impuls vergangen?
      else tempoflag=1;
      tempopos[dig]=tempopos[dig]^1; // Exclusiv Oder: aus 0 mach 1 oder aus 1 mach 0
      if(digitalRead(dip1)==HIGH) returnwert=1+tempoflag; //welche Drehrichtung?
      else                        returnwert=3+tempoflag;
      if((returnwert==2 && returnwert_old >2) || (returnwert==4 && returnwert_old <3)) returnwert=0; //ungültiger Wert
      returnwert_old=returnwert;
      return(returnwert);
    }  
  }
  return(0);
}
//*** Strombegrenzung *************************************************
boolean strombegrenzung() {
  //float volt_ist;
  float volt_ist =float(analogRead(0)*15.0/1024+0.02);
  if(volt_ist <10.0) { //analogRead(2) ist genauer als die Soll- und Ist-Spannung zu vergleichen
    if(analogRead(2)>=550) return (false); //Strombegrenzung ist nicht aktiv
    else return(true); //Strombegrenzung ist aktiv
  }
  else {
    if((float (spannung_soll) *15.0/255.0) < (volt_ist+0.5)) return(false); //0.5 ist ein willkürlicher Toleranzwert
    else return(true);
  }
}
