-- Scan the I2C Bus for devices
id=0
sda=2	-- GPIO 2 for SDA Line
scl=1	-- GPIO 1 for SCL Line

-- initialize i2c, set pin1 as sda, set pin2 as scl
i2c.setup(id,sda,scl,i2c.SLOW)
	
-- user defined function: read from reg_addr content of dev_addr
function read_reg(dev_addr, reg_addr)
     i2c.start(id)
     i2c.address(id, dev_addr ,i2c.TRANSMITTER)
     i2c.write(id,reg_addr)
     i2c.stop(id)
     i2c.start(id)
     i2c.address(id, dev_addr,i2c.RECEIVER)
     c=i2c.read(id,1)
     i2c.stop(id)
     return c
end

print("Scan the I2C Bus for devices")

for i=0,127 do
     if (string.byte(read_reg(i, 0))==0) then
        print("I2C device found at Address 0x"..string.format("%02X",i))
     end
end
