/*
   Make 4/2018
   https://www.heise.de/make/
   LED-Nixie Ansteuerung
   Stellt fortlaufend alle Zahlen von 00-99 dar und wechselt alle 10 Zahlen die Farbe
*/

#include <Adafruit_NeoPixel.h>    // https://github.com/adafruit/Adafruit_NeoPixel

uint8_t PIN = 7;       // Datenpin. ca. 220-470 Ohm Widerstand zusaetzlich!
uint8_t DIGITS = 2;    // Anzahl Digits à 20 LEDs
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(DIGITS * 20, PIN, NEO_GRB + NEO_KHZ800);     // Konstruktor WS2812
struct RGB
{
  uint8_t red;
  uint8_t grn;
  uint8_t blu;
};

/*
 * @brief   Ausgabe einer Ziffer auf einerm Digit
 * @param   Digit (ab 0)
 *          Zahl (0..9)
 *          Farbe (RGB)
 * @return  none
 */
void OutDigit (uint8_t digit, uint8_t value, struct RGB* farbe)
{
  pixels.setPixelColor((digit * 20) + (value * 2), pixels.Color (farbe->red, farbe->grn, farbe->blu));        // 1. LED
  pixels.setPixelColor((digit * 20) + (value * 2) + 1, pixels.Color (farbe->red, farbe->grn, farbe->blu));    // 2. LED
}

/*
 * @brief   Ausgabe einer Zahl
 * @param   Zahl (0-65536)
 *          Farbe (RGB)
 *          Fuehrende Nullen anzeigen (0=nein, 1=ja)
 * @return  none
 */
void OutZahl (uint16_t value, struct RGB* farbe, uint8_t leadingZero)
{
  uint8_t pos=0;
  
  pixels.clear();   // alle Farbwerte loeschen

  if (((value >= 10000) || leadingZero) && DIGITS >= 5)    // Zehntausender
  {
    OutDigit (pos, (value / 10000) % 10, farbe);
    pos++;
  }
  
  if (((value >= 1000) || leadingZero) && DIGITS >= 4)    // Tausender
  {
    OutDigit (pos, (value / 1000) % 10, farbe);
    pos++;
  }
  
  if (((value >= 100) || leadingZero) && DIGITS >= 3)    // Hunderter
  {
    OutDigit (pos, (value / 100) % 10, farbe);
    pos++;
  }
  
  if (((value >= 10) || leadingZero) && DIGITS >= 2)    // Zehner
  {
    OutDigit (pos, (value / 10) % 10, farbe);
    pos++;
  }
  
  OutDigit (pos, value % 10, farbe);                    // Einer

  pixels.show();
}

void setup(){}

void loop()
{
  RGB farbe;
  uint8_t u, i;
  pixels.begin();     // NeoPixel library initialisieren

  while (1)
  {
    for (u = 0; u <= 9; u++)      // Zehner
    {
      farbe.red = random (0, 25) * 10;     // Zufaellige Farbe, nur grobe Abstufung
      farbe.grn = random (0, 25) * 10;
      farbe.blu = random (0, 25) * 10;
      
      for (i = 0; i <= 9; i++)    // Einer
      {
        OutZahl (u * 10 + i, &farbe, 1);
        delay(100);
      }
    }
  }
}
